<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslShowHelp" select="cif:xslShowHelp"/>
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Terrain Crossing Features Report -->    
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>
                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/engineer/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Výpis křížení prvků terénu</title>
            </head>
            <body>
                <xsl:choose>
                    <xsl:when test="$xslShowHelp = 'true'">
                        <xsl:call-template name="StyleSheetHelp"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="InRoads">
                            <center>
                                <!-- Report Title -->
                                <h2 lang="en">Výpis křížení prvků terénu</h2>
                                <p lang="en">
                                    Datum výpisu: &#xa0;<xsl:value-of select="cif:date()"/><br/>
                                    Čas: &#xa0;<xsl:value-of select="cif:time()"/>
                                </p>
                            </center>
                            <!-- crossing features -->
                            <xsl:for-each select="CrossingFeatures">
                                <table align="center" border="1" cellpadding="2" cellspacing="0">
                                    <thead style="display:table-header-group">
                                        <tr>
                                            <th lang="en" valign="bottom">Východní (X)</th>
                                            <th lang="en" valign="bottom">Severní (Y)</th>
                                            <th lang="en" valign="bottom">Výška na prvku 1</th>
                                            <th lang="en" valign="bottom">Výška na prvku 2</th>
                                            <th lang="en" valign="bottom">Rozdíl výšek</th>
                                            <th lang="en" valign="bottom">Prvek 1 Typ</th>
                                            <th lang="en" valign="bottom">Prvek 2 Typ</th>
                                        </tr>
                                    </thead>
                                    <tbody>
				        <xsl:for-each select="Crossing">
				            <tr>
                                                <td align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(IntersectionPoint/@easting))"/>
                                                </td>
                                                <td align="right">
                                                    <xsl:value-of select="cif:ordinateFormat(number(IntersectionPoint/@northing))"/>
                                                </td>
                                                <td align="left">
			                            <xsl:value-of select="cif:distanceFormat(number(@levelOnFeature1))"/>
				                </td>
				                <td align="left">
					            <xsl:value-of select="cif:distanceFormat(number(@levelOnFeature2))"/>
				                </td>
				                <td align="left">
					            <xsl:value-of select="cif:distanceFormat(number(@levelDifference))"/>
				                </td>
				                <td align="left">
					            <xsl:value-of select="@feature1"/>
				                </td>
				                <td align="left">
					            <xsl:value-of select="@feature2"/>
				                </td>
				            </tr>
				        </xsl:for-each>
                                    </tbody>
                                </table>
                                <hr />                                                               
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:otherwise>
                </xsl:choose>
            </body>
        </html>
    </xsl:template>
    <xsl:template name="StyleSheetHelp">
        <div class="section1">
			<h4 lang="en">Poznámky</h4>
			<p class="normal1" lang="en">
				Tento formulář vypisuje všechny body křížení Civil terénu.
			</p>
			<p class="normal1" lang="en">
				Pro tento výpis musíte vytvořit Body křížení prvků výběrem Modelování terénu &gt; Výpis křížení &gt; Výpis.
			</p>
			<p class="small" lang="en">
				<em>&#xa9; 2006 Bentley Systems, Inc</em>
			</p>
        </div>
    </xsl:template>
</xsl:stylesheet>
